#version 140

#extension GL_ARB_compatibility : enable
#extension GL_ARB_fragment_coord_conventions : enable
#extension GL_KHR_blend_equation_advanced : enable
// get inputs from scene
// if an input is missing it will default to 1.0
uniform float zeroPercent;
uniform float onePercent;
uniform float mixPercent;

uniform sampler2D texture0;
uniform sampler2D texture1;
varying vec4 gl_TexCoord[];


void main(void)
{ 
vec4 vTexCoord = gl_TexCoord[0];
float mixP = 0.0; 
float oneP = 0.0;
float zeroP = 0.0;

highp vec4 zero = texture2D(texture0,vTexCoord.xy); // input zero 0
highp vec4 one = texture2D(texture1, vTexCoord.xy); // input one 1 

// test all the inputs, if 0. then set to 1.0
if (mixPercent == 0.) {mixP = 1.0;} else { mixP = mixPercent;
}
if (onePercent == 0.) {oneP = 1.0;} else { oneP = onePercent;
}
if (zeroPercent == 0.) {zeroP = 1.0;} else { zeroP = zeroPercent;
}

// combine the inputs using the percentage values 
gl_FragColor = ((mixP * ( (zeroP * zero) + (mixP * one)) ) * gl_Color);
gl_FragColor.a = (one.a * zero.a); // make the alpha the combined apha of both input channels
//gl_FragColor.a = length ( vec3(1.0) - gl_FragColor.rgb );
}
